from Deadline.Scripting import *
import pprint

def __main__(*args):
    network_settings = RepositoryUtils.GetNetworkSettings()
    aws_portal_settings = RepositoryUtils.GetAWSPortalSettings()
    get_asset_server_settings()
    check_mapped_drives(network_settings)
    check_licensing(network_settings, aws_portal_settings)
    check_limits()
    override_check(aws_portal_settings)

def get_asset_server_settings():
    root_directories = ClientUtils.ExecuteCommandAndGetOutput(["GetAssetServerSetting", "FileTransferDirectories"]).rstrip()
    asset_server_ip = ClientUtils.ExecuteCommandAndGetOutput(["GetAssetServerSetting", "AssetServerIP"]).rstrip()
    asset_server_port = ClientUtils.ExecuteCommandAndGetOutput(["GetAssetServerSetting", "AssetServerPort"]).rstrip()
    asset_server_ip_override = ClientUtils.ExecuteCommandAndGetOutput(["GetAssetServerSetting", "AssetServerPublicIPOverride"]).rstrip()
    
    print("----Asset Server Settings----")
    print("Asset Server IP: {}\nAsset Server Port: {}\nAsset Server Public IP Port Override: {}".format(asset_server_ip, asset_server_port, asset_server_ip_override))

    if asset_server_ip == "127.0.0.1":
        print("The Asset Server IP: {} is set to only allow pre-caching of jobs submitted from the AWS Portal Server, set the private ip address of the machine hosting the AWS Portal Asset Server to allow caching from machines on the local network".format(asset_server_ip))
    
    print("Root Directories:")
    root_directories = root_directories.split(',')
    for root in root_directories:
        print("  " + str(root))

def check_mapped_drives(network_settings):
    print("\n----Checking Mapped Drives----")
    drive_count = 0
    for drive in network_settings.MappedDrives:
        if drive.LocalPath != "":
            drive_count =+ 1
            print(drive.LocalPath)
    if drive_count == 0:
        print("WARNING: No Drive Mappings Set, if you are specifying mapped network drives in root directories, entries must be created in Deadline Monitor > Tools > Configure Repository Options > Mapped Drives. Ignore this Warning if UNC or local disks are being used.")

def check_limits():
    print("\n----Checking UBL Limits, there should be a limit listed for each UBL product used----")
    limit_group_list = RepositoryUtils.GetLimitGroups(True)
    for group in limit_group_list:
        if group.LimitGroupUseThirdPartyUBL == True:
            print(group.Name)

def check_licensing(network_settings, aws_portal_settings):
    print("\n----BYOL Servers----")
    for server in aws_portal_settings.AdditionalServers:
        print(server.Name)
        try:
            if network_settings.DynamicLicensingMode == False and server.EnvironmentName == "Thinkbox":
                print("Thinkbox BYOL is being specified but Dynamic Licensing is not enabled. To have AWS Portal Workers obtain Standard licensing, enable Dynamic Licensing in Deadline Monitor > Tools > Configure Repository Options > Usage Based Licensing.")
        except AttributeError:
            print("Unable to determine license settings. This should no longer be needed after 10.1.23")

    print("\n----AWS Portal Environment Variables----")
    for env in aws_portal_settings.AdditionalEnvVars:
        print(env.Name)
    
    print("\n----UBL Certificate Directory---")
    if aws_portal_settings.SyncCertsDirectory == "":
        print("No UBL Certificate Directory is specified. Download UBL certficiates into a directory from the Customer Portal and specify it in Deadline Monitor > View > New Panel > AWS Portal > Advanced > Usage-Based Licensing Certificate Directory. ")
    else:
        print(aws_portal_settings.SyncCertsDirectory)

    print("\n----UBL Repository Settings----")
    if network_settings.UsageBasedURL == "" or network_settings.UsageBasedActivationCode == "" or network_settings.UseCloudLicenseServer == False:
        print("The Cloud License URL and/or Activation code is missing or not enabled. Check Deadline Monitor > Tools > Configure Repository Options > Usage Based Licensing")
    else:
        print("{:<40} {:<40}".format("Cloud Server URL", network_settings.UsageBasedURL))
        print("{:<40} {:<40}".format("Cloud Server Activation Code:", network_settings.UsageBasedActivationCode))
        print("{:<40} {:<40}".format("Cloud Server Enabled:", network_settings.UseCloudLicenseServer))

    if network_settings.UBLUseForwarderForUBL == True:
        print("WARNING: Web forwarding is enabled, this feature is not compatible with AWS Portal. Disable in Deadline Monitor > Tools > Configure Repository Options.")

    if network_settings.GatherResourceUsageDuringRendering == False:
        print("WARNING: Auto-detect 3rd Party Usage Based License Consumption is disabled. If this is not enabled consumption of UBL minutes will begin when a worker picks up a job. Enable to have consumption start when a Worker checks out a license. Enable in Deadline Monitor > Tools > Configure Repository Options > Usage Based Licensing.")

def override_check(aws_portal_settings):
    print("\n----Checking for ip overrides----")
    print("AWS Portal Link Local Override: " + aws_portal_settings.AWSPortalLinkLocalIpOverride)
    print("AWS Portal Public Local Override: " + aws_portal_settings.AWSPortalLinkPublicIpOverride)
